
!RAI Program (version 1.0) gfortran.exe -ffree-line-length-none main.f90 -o main.o  & gfortran.exe -static main.o -o RAI.exe OR gfortran -ffree-line-length-none main.f90 -o main
!-----------------------------------------------------------------------------
module def
implicit none
!-----------------------------------------------------------------------------
! Abbr:
! def ---> DEFinition      iso -> ISOtope                     t ---> Title
! atm ---> AToM            ie --> first Ionization Energy     c ---> Cube
! vect --> VECTor          ea --> Electron Affinity energy    d ---> Data
! dfrnt -> DiFfeReNT       ieea = ie - ea                     mol -> MOLecule
! fcp ---> Fime name of Corrected electrostatic Potential     ard -> Atom RaDii
! dcp ---> Data of Corrected electrostatic Potential file     ar --> Atom Radii
! esp ---> ElectroStatic Potential
!-----------------------------------------------------------------------------
! input files:
! fn1 / fn2 / fn3 --> charge files  ( -1 e ) / ( 0 e ) / ( +1 e )
!       fn4       --> esp
!-----------------------------------------------------------------------------
! middle files:
! fng / fzr / fps --> filenames of Fukui NeGative / Fukui ZeRo / Fukui PoSitive
!       fcp       --> File name of Corrected electrostatic Potential file
!-----------------------------------------------------------------------------
!!! --->  atom radii
    type atm_rad
      character (len=2)  :: s           ! s == atom symbol
      integer            :: n           ! n == atomic number
      real               :: r           ! r == atom radii
      real               :: f           ! f == scale factor for r
    end type atm_rad
!!! --->  title in cube file
    type title
      character (len=200)  :: a         ! 1st line of the title
      character (len=200)  :: b         ! 2nd line of the title
    end type title
!!! --->  cube definition in cube file
    type cube_def                       ! cube_def == cube definition
      integer         :: n_atom         ! n_atom   == the number of atoms
      real(kind=4)    :: base_x         ! base_x   == the base point, x axis position
      real(kind=4)    :: base_y         ! base_y   == the base point, y axis position
      real(kind=4)    :: base_z         ! base_z   == the base point, z axis position
      integer         :: n_vect_a       ! n_vect_a == step number of vector a
      real(kind=4)    :: x_vect_a       ! x_vect_a == x step size of vector a
      real(kind=4)    :: y_vect_a       ! y_vect_a == y step size of vector a
      real(kind=4)    :: z_vect_a       ! z_vect_a == z step size of vector a
      integer         :: n_vect_b       ! n_vect_b == step number of vector b
      real(kind=4)    :: x_vect_b       ! x_vect_b == x step size of vector b
      real(kind=4)    :: y_vect_b       ! y_vect_b == y step size of vector b
      real(kind=4)    :: z_vect_b       ! z_vect_b == z step size of vector b
      integer         :: n_vect_c       ! n_vect_c == step number of vector c
      real(kind=4)    :: x_vect_c       ! x_vect_c == x step size of vector c
      real(kind=4)    :: y_vect_c       ! y_vect_c == y step size of vector c
      real(kind=4)    :: z_vect_c       ! z_vect_c == z step size of vector c
    end type cube_def
!!! --->  molecular definition in cube file
    type atom_def
      integer         :: atm            ! atomic number
      real(kind=4)    :: iso            ! isotope
      real(kind=4)    :: x              ! atomic position, x axis position
      real(kind=4)    :: y              ! atomic position, y axis position
      real(kind=4)    :: z              ! atomic position, z axis position
    end type atom_def
!!! --->  var def for input files
    integer               :: i,j,k              ! universal counter
    integer               :: dfrnt_sign = 0     ! compare the input files' cube definitions
                                                ! same : 0    ;   different : 1
    real(kind=8)          :: ie, ea, ieea       ! ie ---> first Ionization Energy
                                                ! ea ---> Electron Affinity energy
                                                ! ieea -> ieea = ie - ea
    character (len=200)   :: fn1,fn2,fn3,fn4    ! filename of input file one
    ! fn1 --> negative charge file  ( -1 e )    ! t1, c1, atom1, d1  for fn1 ( -1 e )
    ! fn2 --> electron neutral file (  0 e )    ! t2, c2, atom2, d2  for fn2 (  0 e )
    ! fn3 --> positive charge file  ( +1 e )    ! t3, c3, atom3, d3  for fn3 ( +1 e )
    ! fn4 --> electrostatic file    (  esp )    ! t4, c4, atom4, d4  for fn4 (  esp )
    type(title)                  :: t1,        t2,        t3,        t4
    type(cube_def)               :: c1,        c2,        c3,        c4
    type(atom_def) , allocatable :: atom1(:),  atom2(:),  atom3(:),  atom4(:)
    real(kind=8) , allocatable   :: d1(:,:,:), d2(:,:,:), d3(:,:,:), d4(:,:,:)
!!! --->  var def for middle files
    character (len=200)          :: fng,fzr,fps ! filename of fukui results
    ! fng --> Fukui NeGative, electrophilic attacked: f- = (0e) - (+1e)
    ! fzr --> Fukui ZeRo,     free radical attacked : f0 = (1/2) * [ (f+) + (f-) ]
    ! fps --> Fukui PoSitive, nucleophilic attacked : f+ = (-1e) - (0e)
    real(kind=8) , allocatable   :: dng(:,:,:), dzr(:,:,:), dps(:,:,:)
    ! tng, cng, atomng, dng  for : fng --> Fukui NeGative
    ! tzr, czr, atomzr, dzr  for : fzr --> Fukui ZeRo
    ! tps, cps, atomps, dps  for : fps --> Fukui PoSitive
    character (len=200)          :: fcp         ! Filename of Corrected Esp
    real(kind=8) , allocatable   :: dcp(:,:,:)  ! Data of Corrected Esp
!!! ---> var def for hole files
    character(len=200)           :: fn5         ! ar.txt
    character(len=200)           :: fn6         ! filename of the hole data
    real(kind=8)                 :: x_different, y_different, z_different
    real(kind=8)                 :: distance
    real(kind=8)                 :: g = 1000.0
    integer                      :: atom_counter
!!! ---> var def for result files
    character (len=200)          :: fn7         ! rad.txt
    character (len=200)          :: loca        ! The location of output files
    character (len=200)          :: raip        ! filename of the rai results: raip ---> Rai Positive
    character (len=200)          :: rain        ! filename of the rai results: rain ---> Rai Negative
    real(kind=8) , allocatable   :: drp(:,:,:)  ! drp ----> Rai Positive Data
    real(kind=8) , allocatable   :: drn(:,:,:)  ! drn ----> Rai Negative Data
!!! --->  atomic radii
    type(atm_rad), dimension(86) :: ar
    real(kind=8) , allocatable   :: a_rad(:)    ! a_rad --> RADii of Atomic core
    integer                      :: ar_txt_ierror
    character (len=200)          :: ar_txt_error_string
    end module def

program RAI
    use def
!!! --->  get the files names
    write(*,*) '---- RAI(+) and RAI(-) Calculating Program (v 1.0) ----'
    write(*,*) 'Input the cube file name of negative charge file ( -1 e ) unit of length must be Bohr, the same below:'
    read(*,*) fn1
    open(unit = 11, file = fn1, form = 'formatted', status = 'old', action = 'read')
    write(*,*) 'Input the cube file name of electron neutral file (  0 e ):'
    read(*,*) fn2
    open(unit = 12, file = fn2, form = 'formatted', status = 'old', action = 'read')
    write(*,*) 'Input the cube file name of positive charge file  ( +1 e ):'
    read(*,*) fn3
    open(unit = 13, file = fn3, form = 'formatted', status = 'old', action = 'read')
    write(*,*) 'Input the cube file name of electrostatic file    (  esp ):'
    read(*,*) fn4
    open(unit = 14, file = fn4, form = 'formatted', status = 'old', action = 'read')
!!! --->  read the titles (t) and cubes (c)
    read(11,'(a)') t1%a,        t1%b
    read(11,*)     c1%n_atom,   c1%base_x,   c1%base_y,   c1%base_z
    read(11,*)     c1%n_vect_a, c1%x_vect_a, c1%y_vect_a, c1%z_vect_a
    read(11,*)     c1%n_vect_b, c1%x_vect_b, c1%y_vect_b, c1%z_vect_b
    read(11,*)     c1%n_vect_c, c1%x_vect_c, c1%y_vect_c, c1%z_vect_c
    read(12,'(a)') t2%a,        t2%b
    read(12,*)     c2%n_atom,   c2%base_x,   c2%base_y,   c2%base_z
    read(12,*)     c2%n_vect_a, c2%x_vect_a, c2%y_vect_a, c2%z_vect_a
    read(12,*)     c2%n_vect_b, c2%x_vect_b, c2%y_vect_b, c2%z_vect_b
    read(12,*)     c2%n_vect_c, c2%x_vect_c, c2%y_vect_c, c2%z_vect_c
    read(13,'(a)') t3%a,        t3%b
    read(13,*)     c3%n_atom,   c3%base_x,   c3%base_y,   c3%base_z
    read(13,*)     c3%n_vect_a, c3%x_vect_a, c3%y_vect_a, c3%z_vect_a
    read(13,*)     c3%n_vect_b, c3%x_vect_b, c3%y_vect_b, c3%z_vect_b
    read(13,*)     c3%n_vect_c, c3%x_vect_c, c3%y_vect_c, c3%z_vect_c
    read(14,'(a)') t4%a,        t4%b
    read(14,*)     c4%n_atom,   c4%base_x,   c4%base_y,   c4%base_z
    read(14,*)     c4%n_vect_a, c4%x_vect_a, c4%y_vect_a, c4%z_vect_a
    read(14,*)     c4%n_vect_b, c4%x_vect_b, c4%y_vect_b, c4%z_vect_b
    read(14,*)     c4%n_vect_c, c4%x_vect_c, c4%y_vect_c, c4%z_vect_c
!!! --->  setup the atom part
    allocate(atom1(c1%n_atom))
    allocate(atom2(c2%n_atom))
    allocate(atom3(c3%n_atom))
    allocate(atom4(c4%n_atom))
!!! --->  read the atom parts (atom)
    do i = 1, c1%n_atom
      read(11,*) atom1(i)%atm, atom1(i)%iso, atom1(i)%x, atom1(i)%y, atom1(i)%z
    end do
    do i = 1, c2%n_atom
      read(12,*) atom2(i)%atm, atom2(i)%iso, atom2(i)%x, atom2(i)%y, atom2(i)%z
    end do
    do i = 1, c3%n_atom
      read(13,*) atom3(i)%atm, atom3(i)%iso, atom3(i)%x, atom3(i)%y, atom3(i)%z
    end do
    do i = 1, c4%n_atom
      read(14,*) atom4(i)%atm, atom4(i)%iso, atom4(i)%x, atom4(i)%y, atom4(i)%z
    end do
!!! --->  compare the cube definitions and molecular definitions:
  !! -->  compare the cube definitions:
    if ( (    (   c1%n_atom - c2%n_atom   ) .ne.    0 ) .or. (    (   c1%n_atom - c3%n_atom   ) .ne.    0 ) .or. (    (   c1%n_atom - c4%n_atom   ) .ne.    0 ) .or. &
         ( abs(   c1%base_x - c2%base_x   ) .gt. 1e-6 ) .or. ( abs(   c1%base_x - c3%base_x   ) .gt. 1e-6 ) .or. ( abs(   c1%base_x - c4%base_x   ) .gt. 1e-6 ) .or. &
         ( abs(   c1%base_y - c2%base_y   ) .gt. 1e-6 ) .or. ( abs(   c1%base_y - c3%base_y   ) .gt. 1e-6 ) .or. ( abs(   c1%base_y - c4%base_y   ) .gt. 1e-6 ) .or. &
         ( abs(   c1%base_z - c2%base_z   ) .gt. 1e-6 ) .or. ( abs(   c1%base_z - c3%base_z   ) .gt. 1e-6 ) .or. ( abs(   c1%base_z - c4%base_z   ) .gt. 1e-6 ) .or. &
         (    ( c1%n_vect_a - c2%n_vect_a ) .ne.    0 ) .or. (    ( c1%n_vect_a - c3%n_vect_a ) .ne.    0 ) .or. (    ( c1%n_vect_a - c4%n_vect_a ) .ne.    0 ) .or. &
         ( abs( c1%x_vect_a - c2%x_vect_a ) .gt. 1e-6 ) .or. ( abs( c1%x_vect_a - c3%x_vect_a ) .gt. 1e-6 ) .or. ( abs( c1%x_vect_a - c4%x_vect_a ) .gt. 1e-6 ) .or. &
         ( abs( c1%y_vect_a - c2%y_vect_a ) .gt. 1e-6 ) .or. ( abs( c1%y_vect_a - c3%y_vect_a ) .gt. 1e-6 ) .or. ( abs( c1%y_vect_a - c4%y_vect_a ) .gt. 1e-6 ) .or. &
         ( abs( c1%z_vect_a - c2%z_vect_a ) .gt. 1e-6 ) .or. ( abs( c1%z_vect_a - c3%z_vect_a ) .gt. 1e-6 ) .or. ( abs( c1%z_vect_a - c4%z_vect_a ) .gt. 1e-6 ) .or. &
         (    ( c1%n_vect_b - c2%n_vect_b ) .ne.    0 ) .or. (    ( c1%n_vect_b - c3%n_vect_b ) .ne.    0 ) .or. (    ( c1%n_vect_b - c4%n_vect_b ) .ne.    0 ) .or. &
         ( abs( c1%x_vect_b - c2%x_vect_b ) .gt. 1e-6 ) .or. ( abs( c1%x_vect_b - c3%x_vect_b ) .gt. 1e-6 ) .or. ( abs( c1%x_vect_b - c4%x_vect_b ) .gt. 1e-6 ) .or. &
         ( abs( c1%y_vect_b - c2%y_vect_b ) .gt. 1e-6 ) .or. ( abs( c1%y_vect_b - c3%y_vect_b ) .gt. 1e-6 ) .or. ( abs( c1%y_vect_b - c4%y_vect_b ) .gt. 1e-6 ) .or. &
         ( abs( c1%z_vect_b - c2%z_vect_b ) .gt. 1e-6 ) .or. ( abs( c1%z_vect_b - c3%z_vect_b ) .gt. 1e-6 ) .or. ( abs( c1%z_vect_b - c4%z_vect_b ) .gt. 1e-6 ) .or. &
         (    ( c1%n_vect_c - c2%n_vect_c ) .ne.    0 ) .or. (    ( c1%n_vect_c - c3%n_vect_c ) .ne.    0 ) .or. (    ( c1%n_vect_c - c4%n_vect_c ) .ne.    0 ) .or. &
         ( abs( c1%x_vect_c - c2%x_vect_c ) .gt. 1e-6 ) .or. ( abs( c1%x_vect_c - c3%x_vect_c ) .gt. 1e-6 ) .or. ( abs( c1%x_vect_c - c4%x_vect_c ) .gt. 1e-6 ) .or. &
         ( abs( c1%y_vect_c - c2%y_vect_c ) .gt. 1e-6 ) .or. ( abs( c1%y_vect_c - c3%y_vect_c ) .gt. 1e-6 ) .or. ( abs( c1%y_vect_c - c4%y_vect_c ) .gt. 1e-6 ) .or. &
         ( abs( c1%z_vect_c - c2%z_vect_c ) .gt. 1e-6 ) .or. ( abs( c1%z_vect_c - c3%z_vect_c ) .gt. 1e-6 ) .or. ( abs( c1%z_vect_c - c4%z_vect_c ) .gt. 1e-6 )      &
       ) dfrnt_sign = 1
  !! -->  compare the molecular definitions
    do i = 1, c1%n_atom
    if ( (   ( atom1(i)%atm - atom2(i)%atm ).ne.    0 ) .or. (   ( atom1(i)%atm - atom3(i)%atm ).ne.    0 ) .or. (   ( atom1(i)%atm - atom4(i)%atm ).ne.    0 ) .or. &
         (abs( atom1(i)%iso - atom2(i)%iso ).gt. 1e-6 ) .or. (abs( atom1(i)%iso - atom3(i)%iso ).gt. 1e-6 ) .or. (abs( atom1(i)%iso - atom4(i)%iso ).gt. 1e-6 ) .or. &
         (abs( atom1(i)%x   - atom2(i)%x   ).gt. 1e-6 ) .or. (abs( atom1(i)%x   - atom3(i)%x   ).gt. 1e-6 ) .or. (abs( atom1(i)%x   - atom4(i)%x   ).gt. 1e-6 ) .or. &
         (abs( atom1(i)%y   - atom2(i)%y   ).gt. 1e-6 ) .or. (abs( atom1(i)%y   - atom3(i)%y   ).gt. 1e-6 ) .or. (abs( atom1(i)%y   - atom4(i)%y   ).gt. 1e-6 ) .or. &
         (abs( atom1(i)%z   - atom2(i)%z   ).gt. 1e-6 ) .or. (abs( atom1(i)%z   - atom3(i)%z   ).gt. 1e-6 ) .or. (abs( atom1(i)%z   - atom4(i)%z   ).gt. 1e-6 )      &
       )dfrnt_sign = 1
    end do
    if (dfrnt_sign == 1) then
      write(*,*) 'ATTENTION!!! Cubes definitions are different, please check!'
      pause
      stop
    else if (dfrnt_sign == 0) then
      write(*,*) '----------'
      write(*,*) 'Compare complete. the cubes definitions and molecular definitions are same for these files:'
      write(*,*) 'fn1 --> negative charge file  ( -1 e ):',trim(fn1)
      write(*,*) 'fn2 --> electron neutral file (  0 e ):',trim(fn2)
      write(*,*) 'fn3 --> positive charge file  ( +1 e ):',trim(fn3)
      write(*,*) 'fn4 --> electrostatic file    (  esp ):',trim(fn4)
      write(*,*) 'Each file involves these points:'
      write(*,'(i5,3f12.6)') c1%n_atom,   c1%base_x,   c1%base_y,   c1%base_z
      write(*,'(i5,3f12.6)') c1%n_vect_a, c1%x_vect_a, c1%y_vect_a, c1%z_vect_a
      write(*,'(i5,3f12.6)') c1%n_vect_b, c1%x_vect_b, c1%y_vect_b, c1%z_vect_b
      write(*,'(i5,3f12.6)') c1%n_vect_c, c1%x_vect_c, c1%y_vect_c, c1%z_vect_c
      write(*,*) 'Total data point number:', ( c1%n_vect_a * c1%n_vect_b * c1%n_vect_c )
      write(*,*) '----------'
    end if
!!! --->  setup the data part
    allocate( d1(c1%n_vect_a, c1%n_vect_b, c1%n_vect_c))
    allocate( d2(c1%n_vect_a, c1%n_vect_b, c1%n_vect_c))
    allocate( d3(c1%n_vect_a, c1%n_vect_b, c1%n_vect_c))
    allocate( d4(c1%n_vect_a, c1%n_vect_b, c1%n_vect_c))
    allocate(dps(c1%n_vect_a, c1%n_vect_b, c1%n_vect_c))
    allocate(dzr(c1%n_vect_a, c1%n_vect_b, c1%n_vect_c))
    allocate(dng(c1%n_vect_a, c1%n_vect_b, c1%n_vect_c))
    allocate(dcp(c1%n_vect_a, c1%n_vect_b, c1%n_vect_c))
!!! --->  read the data parts (d)
  !!! --->  1) assign initial value
    do i = 1, c1%n_vect_a
      do j = 1, c1%n_vect_b
        do k = 1, c1%n_vect_c
          d1 (i, j, k) = 0.0
          d2 (i, j, k) = 0.0
          d3 (i, j, k) = 0.0
          d4 (i, j, k) = 0.0
          dps(i, j, k) = 0.0
          dzr(i, j, k) = 0.0
          dng(i, j, k) = 0.0
          dcp(i, j, k) = 0.0
        end do
      end do
    end do
  !!! --->  2) read data value
    do i = 1, c1%n_vect_a
      do j = 1, c1%n_vect_b
        read(11,*) ( d1(i,j,k), k = 1, (c1%n_vect_c) )
        read(12,*) ( d2(i,j,k), k = 1, (c1%n_vect_c) )
        read(13,*) ( d3(i,j,k), k = 1, (c1%n_vect_c) )
        read(14,*) ( d4(i,j,k), k = 1, (c1%n_vect_c) )
      end do
    end do
!!! ---> close the input files
    close(unit = 11)
    close(unit = 12)
    close(unit = 13)
    close(unit = 14)
!!! ---> calculate the Fukui function and corrected esp
    do i = 1, c1%n_vect_a
      do j = 1, c1%n_vect_b
        do k = 1, c1%n_vect_c
          dps(i, j, k) = d1(i, j, k) - d2(i, j, k)
          dng(i, j, k) = d2(i, j, k) - d3(i, j, k)
          dzr(i, j, k) = ( dps(i, j, k) + dng(i, j, k) ) / 2.0
          dcp(i, j, k)  = d4(i, j, k) * 105.9
        end do
      end do
    end do
!!! ---> write the Fukui function files
  !! --> 1. fng --> Fukui NeGative
  !! --> 2. fzr --> Fukui ZeRo
  !! --> 3. fps --> Fukui PoSitive
    if      ( fn1 ( (len(trim(fn1))-3) : len(trim(fn1)) ) == 'cube' ) then
      fn1 = fn1 ( 1:(len(trim(fn1))-5) )
    else if ( fn1 ( (len(trim(fn1))-3) : len(trim(fn1)) ) == '.cub' ) then
      fn1 = fn1 ( 1:(len(trim(fn1))-4) )
    else
      fn1 = fn1 ( 1:1 )
    end if
    fng = trim(fn2)//'_Fukui_function_negative.cube'
    fzr = trim(fn2)//'_Fukui_function_zero.cube'
    fps = trim(fn2)//'_Fukui_function_positive.cube'
    open(unit = 21, file = fng, form = 'formatted', status = 'unknown', action = 'write')
    open(unit = 22, file = fzr, form = 'formatted', status = 'unknown', action = 'write')
    open(unit = 23, file = fps, form = 'formatted', status = 'unknown', action = 'write')
    write(21,*)    'Fukui function negative'
    write(22,*)    'Fukui function zero'
    write(23,*)    'Fukui function positive'
    write(21,*)    'Generated by RAI Prog.'
    write(22,*)    'Generated by RAI Prog.'
    write(23,*)    'Generated by RAI Prog.'
    write(21,*)     c1%n_atom,   c1%base_x,   c1%base_y,   c1%base_z
    write(21,*)     c1%n_vect_a, c1%x_vect_a, c1%y_vect_a, c1%z_vect_a
    write(21,*)     c1%n_vect_b, c1%x_vect_b, c1%y_vect_b, c1%z_vect_b
    write(21,*)     c1%n_vect_c, c1%x_vect_c, c1%y_vect_c, c1%z_vect_c
    write(22,*)     c1%n_atom,   c1%base_x,   c1%base_y,   c1%base_z
    write(22,*)     c1%n_vect_a, c1%x_vect_a, c1%y_vect_a, c1%z_vect_a
    write(22,*)     c1%n_vect_b, c1%x_vect_b, c1%y_vect_b, c1%z_vect_b
    write(22,*)     c1%n_vect_c, c1%x_vect_c, c1%y_vect_c, c1%z_vect_c
    write(23,*)     c1%n_atom,   c1%base_x,   c1%base_y,   c1%base_z
    write(23,*)     c1%n_vect_a, c1%x_vect_a, c1%y_vect_a, c1%z_vect_a
    write(23,*)     c1%n_vect_b, c1%x_vect_b, c1%y_vect_b, c1%z_vect_b
    write(23,*)     c1%n_vect_c, c1%x_vect_c, c1%y_vect_c, c1%z_vect_c
    do i = 1, c1%n_atom
      write(21,*) atom1(i)%atm, atom1(i)%iso, atom1(i)%x, atom1(i)%y, atom1(i)%z
      write(22,*) atom1(i)%atm, atom1(i)%iso, atom1(i)%x, atom1(i)%y, atom1(i)%z
      write(23,*) atom1(i)%atm, atom1(i)%iso, atom1(i)%x, atom1(i)%y, atom1(i)%z
    end do
    do i = 1, c1%n_vect_a
      do j = 1, c1%n_vect_b
        do k = 1, c1%n_vect_c
          write(21,"(1PE13.5)",advance="no") dng(i, j, k)
          if ( ( mod(k,6) == 0 ) .or. ( c1%n_vect_c == k ) ) write(21,*)
          write(22,"(1PE13.5)",advance="no") dzr(i, j, k)
          if ( ( mod(k,6) == 0 ) .or. ( c1%n_vect_c == k ) ) write(22,*)
          write(23,"(1PE13.5)",advance="no") dps(i, j, k)
          if ( ( mod(k,6) == 0 ) .or. ( c1%n_vect_c == k ) ) write(23,*)
        end do
      end do
    end do
    close(unit = 21)
    close(unit = 22)
    close(unit = 23)
!!! ---> write the corrected esp files
  !! --> esp --> ElectroStatic Potential file
  !! --> fcp --> Fime name of Corrected electrostatic Potential file
  !! --> dcp --> Data of Corrected electrostatic Potential file
    fcp = trim(fn2)//'_corrected_ESP.cube'
    open(unit = 24, file = fcp, form = 'formatted', status = 'unknown', action = 'write')
    write(24,*)    'corrected_ESP'
    write(24,*)    'Generated by RAI Prog.'
    write(24,*)     c1%n_atom,   c1%base_x,   c1%base_y,   c1%base_z
    write(24,*)     c1%n_vect_a, c1%x_vect_a, c1%y_vect_a, c1%z_vect_a
    write(24,*)     c1%n_vect_b, c1%x_vect_b, c1%y_vect_b, c1%z_vect_b
    write(24,*)     c1%n_vect_c, c1%x_vect_c, c1%y_vect_c, c1%z_vect_c
    do i = 1, c1%n_atom
      write(24,*) atom1(i)%atm, atom1(i)%iso, atom1(i)%x, atom1(i)%y, atom1(i)%z
    end do
    do i = 1, c1%n_vect_a
      do j = 1, c1%n_vect_b
        do k = 1, c1%n_vect_c
          write(24,"(1PE13.5)",advance="no") dcp(i, j, k)
          if ( ( mod(k,6) == 0 ) .or. ( c1%n_vect_c == k ) ) write(24,*)
        end do
      end do
    end do
    close(unit = 24)
    write(*,*) 'Cube File 1: Fukui_function_negative'
    write(*,*) 'Cube File 2: Fukui_function_zero'
    write(*,*) 'Cube File 3: Fukui_function_positive'
    write(*,*) 'Cube File 4: Corrected_ESP'
    write(*,*) 'Above files have been written into the working dir using the Gaussian-cube format.'
    write(*,*) '----------'
!!! ---> input ie and ea, calculate ieea
  !! --> ie -> first Ionization Energy
  !! --> ea -> Electron Affinity energy
  !! --> ieea = ie - ea
    write(*,*) 'Now please input the value of IE (first ionization energy, unit: a.u.):'
    read(*,*) ie
    write(*,*) 'Now please input the value of EA (electron affinity energy, unit: a.u.):'
    read(*,*) ea
    ieea = ie - ea
!!! ---> input the atomic radii
    write(*,*) 'Please input the location of ar.txt e.g:D:\RAI-102\examples\H2O'
    read(*,*) loca
    fn5 = trim(loca)//'\ar.txt'
    open(unit = 31, file = fn5, form = 'formatted', status = 'old', action = 'read', iostat = ar_txt_ierror, iomsg = ar_txt_error_string)
    if ( ar_txt_ierror /= 0 ) then
      write(*,*) "ar.txt not found. Now RAI program uses the built-in radius values."
      write(*,*) "Infomation from FORTRAN:", trim(ar_txt_error_string)
      ar(1)%r  = 0.120
      ar(2)%r  = 0.140
      ar(3)%r  = 0.182
      ar(4)%r  = 0.177
      ar(5)%r  = 0.174
      ar(6)%r  = 0.170
      ar(7)%r  = 0.155
      ar(8)%r  = 0.152
      ar(9)%r  = 0.147
      ar(10)%r = 0.154
      ar(11)%r = 0.227
      ar(12)%r = 0.173
      ar(13)%r = 0.173
      ar(14)%r = 0.210
      ar(15)%r = 0.180
      ar(16)%r = 0.180
      ar(17)%r = 0.175
      ar(18)%r = 0.188
      ar(19)%r = 0.200
      ar(20)%r = 0.200
      ar(21)%r = 0.200
      ar(22)%r = 0.200
      ar(23)%r = 0.200
      ar(24)%r = 0.200
      ar(25)%r = 0.200
      ar(26)%r = 0.200
      ar(27)%r = 0.200
      ar(28)%r = 0.163
      ar(29)%r = 0.140
      ar(30)%r = 0.139
      ar(31)%r = 0.187
      ar(32)%r = 0.200
      ar(33)%r = 0.185
      ar(34)%r = 0.190
      ar(35)%r = 0.185
      ar(36)%r = 0.202
      ar(37)%r = 0.200
      ar(38)%r = 0.200
      ar(39)%r = 0.200
      ar(40)%r = 0.200
      ar(41)%r = 0.200
      ar(42)%r = 0.200
      ar(43)%r = 0.200
      ar(44)%r = 0.200
      ar(45)%r = 0.200
      ar(46)%r = 0.163
      ar(47)%r = 0.172
      ar(48)%r = 0.158
      ar(49)%r = 0.193
      ar(50)%r = 0.217
      ar(51)%r = 0.200
      ar(52)%r = 0.206
      ar(53)%r = 0.198
      ar(54)%r = 0.216
      ar(55)%r = 0.200
      ar(56)%r = 0.200
      ar(57)%r = 0.200
      ar(58)%r = 0.200
      ar(59)%r = 0.200
      ar(60)%r = 0.200
      ar(61)%r = 0.200
      ar(62)%r = 0.200
      ar(63)%r = 0.200
      ar(64)%r = 0.200
      ar(65)%r = 0.200
      ar(66)%r = 0.200
      ar(67)%r = 0.200
      ar(68)%r = 0.200
      ar(69)%r = 0.200
      ar(70)%r = 0.200
      ar(71)%r = 0.200
      ar(72)%r = 0.200
      ar(73)%r = 0.200
      ar(74)%r = 0.200
      ar(75)%r = 0.200
      ar(76)%r = 0.200
      ar(77)%r = 0.200
      ar(78)%r = 0.172
      ar(79)%r = 0.166
      ar(80)%r = 0.155
      ar(81)%r = 0.196
      ar(82)%r = 0.202
      ar(83)%r = 0.200
      ar(84)%r = 0.200
      ar(85)%r = 0.200
      ar(86)%r = 0.200
      do i = 1, 86
        ar(i)%f = 0.6
      end do
    else
      do i = 1, 86
        read(31,*) ar(i)%r, ar(i)%f
      end do
      close(unit = 31)
    end if
  !! --> calculate the atom radii
    allocate(a_rad(86))
    do i = 1, 86
      a_rad(i) = 0.0
    end do
    do i = 1, 86
    a_rad(i) = ar(i)%r * ar(i)%f * 10* 1.89
    end do
!!! ---> calculate the Rai fountion
  !! --> 1) setup the data part
    allocate(drp(c1%n_vect_a, c1%n_vect_b, c1%n_vect_c))
    allocate(drn(c1%n_vect_a, c1%n_vect_b, c1%n_vect_c))
  !! --> 2) assign initial value
    do i = 1, c1%n_vect_a
      do j = 1,c1%n_vect_b
        do k = 1, c1%n_vect_c
          drp(i,j,k) = 0.0
          drn(i,j,k) = 0.0
        end do
      end do
    end do
  !! --> 3) calculate the Rai function and limit the maximum/maximum value
  !!        to ( (+9.9D99) ~ (+9.9D-98) ) and ( (-9.9D99) ~ (-9.9D-98) )
    do i = 1, c1%n_vect_a
      do j = 1,c1%n_vect_b
        do k = 1, c1%n_vect_c
          drp(i,j,k) = (dps(i,j,k) / ieea) * (exp(1.5 + dcp(i,j,k)))
          if ( drp(i,j,k) > 9.9D99 ) then
            drp(i,j,k) = 9.9D99
          else if ( drp(i,j,k) < -9.9D99 ) then
            drp(i,j,k) = -9.9D99
          else if ( abs(drp(i,j,k)) < 9.9D-98 ) then
            if( drp(i,j,k) > 0 ) then
              drp(i,j,k) = 9.9D-98
            else if( drp(i,j,k) < 0 ) then
              drp(i,j,k) = -9.9D-98
            end if
          end if
          drn(i,j,k) = (dng(i,j,k) / ieea) * (exp(1.5 - dcp(i,j,k)))
          if ( drn(i,j,k) > 9.9D99 ) then
            drn(i,j,k) = 9.9D99
          else if ( drn(i,j,k) < -9.9D99 ) then
            drn(i,j,k) = -9.9D99
          else if ( abs(drn(i,j,k)) < 9.9D-98 ) then
            if( drn(i,j,k) > 0 ) then
              drn(i,j,k) = 9.9D-98
            else if( drn(i,j,k) < 0 ) then
              drn(i,j,k) = -9.9D-98
            end if
          end if
        end do
      end do
    end do
!! --> 5) remove the influence of Atomic core
    do i = 1,c1%n_vect_a
      do j = 1, c1%n_vect_b
        do k = 1, c1%n_vect_c
          judge: do atom_counter = 1, c1%n_atom
            x_different = c1%base_x + (i - 1) * c1%x_vect_a - atom1(atom_counter)%x
            y_different = c1%base_y + (j - 1) * c1%y_vect_b - atom1(atom_counter)%y
            z_different = c1%base_z + (k - 1) * c1%z_vect_c - atom1(atom_counter)%z
            distance = sqrt((x_different ** 2) + (y_different ** 2) + (z_different ** 2))
            if ( distance < a_rad(atom1(atom_counter)%atm) ) then
              drp(i,j,k)=-10.0
              drn(i,j,k)=-10.0
              exit judge
            end if
          end do judge
        end do
      end do
    end do
!!! ---> write the result files
  !! --> raip -> the result of rai positive function
  !! --> rain -> the result of rai negative function
    raip = trim(fn2)//'RAI_plus.cube'
    rain = trim(fn2)//'RAI_minus.cube'
    open(unit = 25, file = raip, form = 'formatted', status = 'unknown', action = 'write')
    open(unit = 26, file = rain, form = 'formatted', status = 'unknown', action = 'write')
    write(25,*) 'Rai function positive'
    write(25,*) 'Generated by RAI Prog.'
    write(26,*) 'Rai function negative'
    write(26,*) 'Generated by RAI Prog.'
    write(25,*) c1%n_atom,   c1%base_x,   c1%base_y,   c1%base_z
    write(25,*) c1%n_vect_a, c1%x_vect_a, c1%y_vect_a, c1%z_vect_a
    write(25,*) c1%n_vect_b, c1%x_vect_b, c1%y_vect_b, c1%z_vect_b
    write(25,*) c1%n_vect_c, c1%x_vect_c, c1%y_vect_c, c1%z_vect_c
    write(26,*) c1%n_atom,   c1%base_x,   c1%base_y,   c1%base_z
    write(26,*) c1%n_vect_a, c1%x_vect_a, c1%y_vect_a, c1%z_vect_a
    write(26,*) c1%n_vect_b, c1%x_vect_b, c1%y_vect_b, c1%z_vect_b
    write(26,*) c1%n_vect_c, c1%x_vect_c, c1%y_vect_c, c1%z_vect_c
    do i = 1, c1%n_atom
      write(25,*) atom1(i)%atm, atom1(i)%iso, atom1(i)%x, atom1(i)%y, atom1(i)%z
      write(26,*) atom1(i)%atm, atom1(i)%iso, atom1(i)%x, atom1(i)%y, atom1(i)%z
    end do
    do i = 1, c1%n_vect_a
      do j = 1, c1%n_vect_b
        do k = 1, c1%n_vect_c
          write(25,"(1PE13.5)",advance="no") drp(i, j, k)
          if ( ( mod(k,6) == 0 ) .or. ( c1%n_vect_c == k ) ) write(25,*)
          write(26,"(1PE13.5)",advance="no") drn(i, j, k)
          if ( ( mod(k,6) == 0 ) .or. ( c1%n_vect_c == k ) ) write(26,*)
        end do
      end do
    end do
    close(unit = 25)
    close(unit = 26)
    write(*,*) 'Cube File 5: Rai_function_positive'
    write(*,*) 'Cube File 6: Rai_function_negative'
    write(*,*) 'Above files have been written into the working dir using the Gaussian-cube format.'
!!! ---> end the program
    deallocate(atom1)
    deallocate(atom2)
    deallocate(atom3)
    deallocate(atom4)
    deallocate(d1)
    deallocate(d2)
    deallocate(d3)
    deallocate(d4)
    deallocate(dps)
    deallocate(dzr)
    deallocate(dng)
    deallocate(dcp)
    deallocate(a_rad)
    deallocate(drp)
    deallocate(drn)
    pause
end program RAI

